﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class OneBallBehaviour : MonoBehaviour
{
    private Rigidbody rigidBody;
    private Vector3 forceAdded;
    public float Multiplier = 100f;
    public float MaxMultiplier = 3000f;

    void Awake()
    {
        rigidBody = GetComponent<Rigidbody>();
    }

    // Metoda Start jest wywoływana przed pierwszą aktualizacją klatki.
    void Start()
    {
        // Odczekanie sekundy, a następnie wywoływanie metody MoveMe co 1,5 sekundy.
        InvokeRepeating("MoveMe", 1f, 1.5f);
    }

    private void MoveMe()
    {
        /*
         * Pierwsza iteracja w MoveMe.
         * 
        // Usuwanie siły dodanej przez MoveMe przy poprzednim wywołaniu.
        rigidBody.velocity = Vector3.zero;

        // Dodawanie siły działającej w losowym kierunku.
        forceAdded = Random.insideUnitSphere * 500f;
        rigidBody.AddForce(forceAdded);
        */

        /*
         * Druga iteracja w MoveMe.
         * 
        if (forceAdded == Vector3.left * 500f)
        {
            forceAdded = Vector3.forward * 500f;
        }
        else if (forceAdded == Vector3.forward * 500f)
        {
            forceAdded = Vector3.right * 500f;
        }
        else if (forceAdded == Vector3.right * 500f)
        {
            forceAdded = Vector3.back * 500f;
        }
        else
        {
            forceAdded = Vector3.left * 500f;
        }

        rigidBody.velocity = Vector3.zero;
        rigidBody.AddForce(forceAdded);
        */

        forceAdded = new Vector3(Multiplier - Random.value * Multiplier * 2,
               0, Multiplier - Random.value * Multiplier * 2);
        rigidBody.AddForce(forceAdded);
        Multiplier += 100f;
        if (Multiplier > MaxMultiplier) Destroy(gameObject);
    }


    // Metoda Update jest wywoływana raz dla każdej klatki.
    void Update()
    {
        Debug.DrawRay(transform.position, forceAdded, Color.white);
    }
}
